<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Chat;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Broadcast;
use Illuminate\Support\Facades\Log;

use TaylanUnutmaz\AgoraTokenBuilder\RtcTokenBuilder;



class ChatController extends Controller
{
    public function getMessages($receiverId)
    {
        $authToken = session('auth_token');
        
        $user = User::where('auth_token', $authToken)->first();
        
        if (!$user) {
            return response()->json(['error' => 'User not authenticated'], 401);
        }
    
        $userId = $user->id;
    
        // Fetch chats between the authenticated user and the receiver
        $chats = Chat::where(function ($query) use ($userId, $receiverId) {
            $query->where('user_id', $userId)
                  ->where('receiver_id', $receiverId);
        })->orWhere(function ($query) use ($userId, $receiverId) {
            $query->where('user_id', $receiverId)
                  ->where('receiver_id', $userId);
        })->get();
    
        // Transform the chats to include senderType
        $chats = $chats->map(function ($chat) use ($userId) {
            $chat->senderType = $chat->user_id === $userId ? 'user' : 'receiver';
            return $chat;
        });
    
        return response()->json($chats);
    }
    

   
    public function sendMessage(Request $request)
    {
        
        $request->validate([
            'receiver_id' => 'required|exists:users,id',
            'message' => 'required|string',
        ]);

        $authToken = session('auth_token');
        
        // Fetch the user based on auth token
        $user = User::where('auth_token', $authToken)->first();


        

        $chat = Chat::create([
            'user_id' => $user->id,
            'receiver_id' => $request->receiver_id,
            'message' => $request->message,
        ]);

       
        broadcast(new \App\Events\NewMessage($chat));

        return response()->json($chat);
    }


//     public function generateAgoraToken(Request $request)
// {
//     $appID = '5f7750d1d4014970a4b6d5b8f26022eb';
//     $appCertificate = 'ac407ca3b02147dfad0863e50588dc19';
//     $channelName = $request->channel_name;
//     $uid = $request->uid ?? 0; // Use 0 for a default UID
//     $role = RtcTokenBuilder::ROLE_PUBLISHER;
//     $expireTimeInSeconds = 3600; // Token valid for 1 hour
//     $currentTime = now()->timestamp;
//     $privilegeExpireTime = $currentTime + $expireTimeInSeconds;

//     $token = RtcTokenBuilder::buildTokenWithUid($appID, $appCertificate, $channelName, $uid, $role, $privilegeExpireTime);

//     return response()->json(['token' => $token]);
// }



// Backend PHP
public function generateAgoraToken(Request $request) {
    $appID = '5f7750d1d4014970a4b6d5b8f26022eb';
    $appCertificate = 'ac407ca3b02147dfad0863e50588dc19';
    $channelName = $request->channel_name;
    $uid = (int)$request->uid; // Ensure UID is an integer
    $role = RtcTokenBuilder::RolePublisher;
    $expireTimeInSeconds = 3600;
    $currentTimestamp = time();
    $privilegeExpireTime = $currentTimestamp + $expireTimeInSeconds;

    try {
        $token = RtcTokenBuilder::buildTokenWithUid(
            $appID,
            $appCertificate,
            $channelName,
            $uid,
            $role,
            $privilegeExpireTime
        );

        return response()->json([
            'token' => $token,
            'appId' => $appID,
            'channel' => $channelName,
            'uid' => $uid
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'error' => 'Token generation failed: ' . $e->getMessage()
        ], 500);
    }
}




}





