<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\User;

class CheckAuthToken
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        // Retrieve the auth_token from the session
        $authToken = session('auth_token');
        
        if (!$authToken) {
            // If there is no token in the session, redirect to login
            return redirect()->route('login');
        }

        // Check if the token exists in the database
        $user = User::where('auth_token', $authToken)->first();

        if (!$user) {
            // If the token is invalid or doesn't exist, redirect to login
            return redirect()->route('login');
        }

        // Token is valid, proceed with the request
        return $next($request);
    }
    
}





