<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chat extends Model
{
    use HasFactory;


    protected $fillable = ['user_id', 'receiver_id', 'message'];

    // Relationship to User (sender)
    public function sender()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    // Relationship to User (receiver)
    public function receiver()
    {
        return $this->belongsTo(User::class, 'receiver_id');
    }
}
