import { EventEmitter, RetryConfiguration } from '@agora-js/shared';

interface ConnectInfo {
    appId: string;
    areaCode: string | string[];
    cname: string;
    cid: number;
    sid: string;
    token: string | null;
    uid: number;
    vid: number;
}

/**
 * Configuration for the video moderation service. Used in the {@link setImageModeration} method.
 */
interface ImageModerationConfiguration {
    /**
     * Interval for taking video screenshots (ms), with a minimum value of `1000`.
     */
    interval: number;
    /**
     * Additional information, with a maximum length of 1024 bytes.
     *
     * The SDK sends the screenshots and additional information on the video content to the Agora server. Once the video screenshot and upload process is completed, the Agora server sends the additional information and the callback notification to your server.
     */
    extraInfo?: string;
    /**
     * @ignore
     */
    vendor?: string;
}

type TRteServiceName = "ChannelMediaRelay" | "LiveStreaming" | "ImageModeration" | "ContentInspect" | "DataStream" | "P2PChannel" | "PlanBConnection";
interface IRteService<T = any, R = any> {
    name: TRteServiceName;
    create: (...args: any[]) => T;
    createSubmodule?: (...args: any[]) => R;
}

declare class ImageModeration extends EventEmitter {
    name: string;
    private _connectionState;
    private get connectionState();
    private set connectionState(value);
    private _sequence;
    private _moderationStartTime;
    private _workerConnection;
    private _workerMessageLengthLimit;
    private _qualityRatio;
    private _connectInfo;
    private _cancelTokenSource;
    private _retryConfig;
    private _moderationInterval;
    private _moderationTimer;
    private _moderationMode;
    private _quality;
    private _qualityTimer;
    private _ticket?;
    private _moderationIntervalMinimum;
    private _uploadFailedNum;
    private _uploadNum;
    private _uploadTimer;
    private _extraInfo?;
    private _vendor;
    private _encoder;
    private get quality();
    private set quality(value);
    private _moderationId;
    constructor(config: ImageModerationConfiguration);
    init(connectInfo: ConnectInfo, retryConfig: Partial<RetryConfiguration>): Promise<void>;
    updateConfig(config: ImageModerationConfiguration): void;
    private requestAP;
    private connectWorker;
    private handleWorkerEvents;
    inspectImage: () => void;
    private static intToLong;
    private requestToInspectImage;
    private generateRequestData;
    close(): void;
}
declare function checkImageModerationConfig(config: ImageModerationConfiguration): void;
interface IImageModerationOptions {
    config: ImageModerationConfiguration;
}
declare const ImageModerationService: IRteService<ImageModeration>;

export { type IImageModerationOptions, ImageModeration, ImageModerationService, checkImageModerationConfig };
