@extends('layouts.app')

@section('title', 'user home Page')

<style>
    .custom-flex-column {
      display: flex;
      flex-direction: column;
      align-items: center;
      
    }
    .font-abhaya {
      font-family: 'Abhaya Libre', serif;
    }
    .custom-flex-normal {
      display: flex;
      justify-content: center;
      align-items: center;
    }

    .custom-radius {
      border-radius: 40px;
    }

    .custom-shadow {
      box-shadow: 0px 6px 6px #46291B !important;
    }

    .text-shadow {
      text-shadow: 0px 2px 5px rgba(0, 0, 0, 0.2);
    }
  </style>


@section('content')
  <div class="h-full w-full max-w-[1400px]">
    <!-- Logo Section -->
    <div class="w-full h-[10%] mb-14 custom-flex-normal">
      <a href="/">
        <img class="h-[3.5vw] min-h-[60px]" src="Images/logo.png" alt="mainLogo">
      </a>
    </div>

    <!-- Background Backdrop -->
    <div class="w-full h-[80%] bg-[#D8D2C2]/40 relative custom-radius backdrop-blur-md flex flex-col items-center">
      <div class="heading mt-4 text-center leading-[40px] sm:leading-[50px] md:leading-[70px] lg:leading-[100px] relative z-20">
        <h1 class="font-abhaya font-semibold text-3xl text-[#AF8F6F] sm:text-4xl md:text-[45px] lg:text-[60px] text-headingFont text-shadow">
          YOUR SOUL
        </h1>
        <h1 class="font-abhaya font-semibold text-[55px] sm:text-[65px] md:text-[85px] lg:text-[100px] text-shadow">
          WANTS
        </h1>
      </div>

      <!-- Buttons Section -->
      <div class="flex flex-col sm:flex-row gap-4 items-center justify-center mt-8">
    <a class="relative z-60" href="{{ route('chat', ['type' => 'yourself']) }}">
        <button class="py-2 px-6 active:scale-95 transform transition-all font-semibold border-2 border-[#5D432A] rounded-[40px] whitespace-nowrap bg-[#AF8F6F] uppercase custom-shadow">
            XPRESS YOURSELF
        </button>
    </a>
    <a class="relative z-60" href="{{ route('chat', ['type' => 'desire']) }}">
        <button class="py-2 px-6 active:scale-95 transform transition-all font-semibold border-2 border-[#5D432A] rounded-[40px] whitespace-nowrap bg-[#AF8F6F] uppercase custom-shadow">
            XPLORE DESIRES
        </button>
    </a>
</div>


      <!-- Background Image -->
      <img
        class="absolute left-1/2 ml-1 translate-x-[-50%] lg:h-[260px] xl:h-[240px] h-[300px] portrait:h-[60vw] portrait:sm:h-[50vw] min-h-[200px] w-auto bottom-0  md:ml-3 z-0"
        src="Images/homepageimg.png"
        alt="virtual-meet-img"
      />
    </div>
  </div>
@endsection