<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ChatController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('web.home');
});

//login route
Route::get('/login', [UserController::class, 'login'])->name('login');
Route::post('/login', [UserController::class, 'sendotp'])->name('login.submit');
Route::post('/verify-otp', [UserController::class, 'verifyOtp'])->name('verify.otp');



Route::get('/logout', function () {
    Auth::logout(); // Log out the user
    Session::flush(); // Clear all session data
    return redirect('/login')->with('success', 'You have been logged out successfully.');
})->name('logout');


Route::middleware('auth.token')->group(function () {
    Route::get('/home', [UserController::class, 'home'])->name('home');
    Route::get('/chat/{type}', [UserController::class, 'chat'])->name('chat');
    Route::get('/get-interests/{type?}', [UserController::class, 'getInterests'])->name('get.interests');

    Route::post('/store-interests', [UserController::class, 'store'])->name('connect.similar');
    Route::post('/send-message', [ChatController::class, 'sendMessage'])->name('chat.sendMessage');
    Route::get('/messages/{receiverId}', [ChatController::class, 'getMessages'])->name('chat.getMessages'); 
    Route::post('/generatetoken', [ChatController::class, 'generateAgoraToken'])->name('generate.agora.token');
    Route::post('/update-active-status', [UserController::class, 'updateActiveStatus'])->name('update.active.status');


    
});







